{*****************************************
"The Path" problem and code submitted by 
Ray Hamel for the ACM Pacific NW Programming
Contest on 15 November 1997.
*****************************************}
program Path (InFile, OutFile);
 const
  Max = 81;
 type
  FileType = Text;
  SizeType = 0..Max;
  BoardType = array[SizeType, SizeType] of Char;
 var
  Board: BoardType;
  Size: SizeType;
  I, J: SizeType;
  Change: Boolean;
  Found: Char;
  InFile, OutFile: FileType;

 procedure GetBoard (var F: FileType; var B: BoardType; var S: SizeType);
  var
   I, J: SizeType;
 begin
  ReadLn(F, S);
  if S <> 0 then
   begin
    ReadLn(F);			{Blank line between Size and Board}
    for I := 1 to S do
     begin				{Surround the board with 'U's}
      B[I, 0] := 'U';
      B[I, S + 1] := 'U';
      B[0, I] := 'U';
      B[S + 1, I] := 'U';
      for J := 1 to S do	{Read characters into Board, one row at a time.}
       Read(F, B[I, J]);
      ReadLn(F)				{End of a Board row}
     end;
    ReadLn(F)					{Blank line after the Board}
   end
 end;

 function Adjust (var B: BoardType; I, J: SizeType; Ch: Char): Boolean;
  var
   Adjacent: Boolean;
 begin
  Adjacent := False; 		{Next, check to see if an adjacent square is on 
path back to beginning.}
  if (B[I - 1, J] = Ch) or (B[I, J - 1] = Ch) or (B[I + 1, J] = Ch) or (B[I, J + 1] = Ch) 
then
   Adjacent := True;
  Adjust := Adjacent;
  if Adjacent then			{This function has a side effect, changing an 
entry on a path.}
   B[I, J] := Ch {Capital letter changed to lower case if there is a path back to 
beginning edge.}
 end;{Adjust}

begin
 Reset(InFile, 'PathData.txt');
 ReWrite(OutFile, 'PathOut.txt');
 repeat
  GetBoard(InFile, Board, Size);
  if Size <> 0 then
   begin
    Found := ' ';
    for J := 1 to Size do
     begin						{Change a letter to lower case if it is 
on its starting edge.}
      if Board[1, J] = 'B' then
       Board[1, J] := 'b';
      if Board[J, 1] = 'W' then
       Board[J, 1] := 'w'
     end;
    repeat
     for J := 1 to Size do
      if (Board[Size, J] = 'b') then
       Found := 'b'
      else if (Board[J, Size] = 'w') then
       Found := 'w';
     if Found = ' ' then		{In this case, there is no winning path yet.}
      begin
       Change := False;
       for I := 1 to Size do			{this sections grows paths longer, if 
possible.}       for J := 1 to Size do
       if Board[I, J] = 'W' then
       Change := Change or Adjust(Board, I, J, 'w')
       else if Board[I, J] = 'B' then
       Change := Change or Adjust(Board, I, J, 'b')
      end
    until (Found <> ' ') or not Change;  {Stop interation if winning path exists or 
no path growth.}
    case Found of
     ' ': 
      WriteLn(OutFile, 'There is no winning path.');
     'w': 
      WriteLn(OutFile, 'White has a winning path.');
     'b': 
      WriteLn(OutFile, 'Black has a winning path.');
    end {Case}
   end
 until Size = 0			{End of Board data sets.}
end.
